from axelrod.action import Action, actions_to_str

from axelrod.player import Player

from axelrod.strategy_transformers import (
    FinalTransformer,
    TrackHistoryTransformer,
)

C, D = Action.C, Action.D

class DynamicTwoTitsForTat(Player):
    """
    A player starts by cooperating and then punishes its opponent's
    defections with defections, but with a dynamic bias towards cooperating
    based on the opponent's ratio of cooperations to total moves
    (so their current probability of cooperating regardless of the
    opponent's move (aka: forgiveness)).

    Names:

     - Dynamic Two Tits For Tat: Original name by Grant Garrett-Grossman.
    """

    name = "Dynamic Two Tits For Tat"
    classifier = {
        "memory_depth": float("inf"),
        "stochastic": True,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent):
        """Actual strategy definition that determines player's action."""
        # First move
        if not opponent.history:
            # Make sure we cooperate first turn
            return C
        if D in opponent.history[-2:]:
            # Probability of cooperating regardless
            return self._random.random_choice(
                opponent.cooperations / len(opponent.history)
            )
        else:
            return C